function	ix = vb_bit_ptn_end(y,status,t_stay)
% Find time points that signal differ from the given integer bit pattern
% only specified bits are examined and other bits are ignored 
% by taking bitwise AND
%     ix = vb_bit_ptn_end(y,status)
%     ix = vb_bit_ptn_end(y,status,t_stay)
% y : event signal
% status : integer defined by bit pattern
%        = 2^n : correspond to check n-th bit
% t_stay : minimum length to stay the specified value [default = 10]
%          'y' should be stay at the value 'status' for more than t_stay
%          Then, 'y' changes to other value from 'status' 
% 
% ix : index corresponding to the end point 
%      'y' changes to other value from 'status' 
%      
% 2009-6-11 Masa-aki Sato
% 2012-1-8  Masa-aki Sato Bug fix
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, t_stay = 10; end;

T = length(y);

% take bitwise AND to ignore irrelevant bit
y = bitand(y,status);

flg = ones(1,T-t_stay);
tt  = 1:T-t_stay;

% 'y' is not 'status' value afterward
flg = flg .* (y(tt + t_stay) ~= status);

% 'y' should be stay at the value 'status' for more than t_stay
for t=0:t_stay-1
	flg = flg .* (y(tt + t) == status);
end

ix = find(flg == 1);
ix = ix + t_stay - 1;

return
