function [meg_info] = vb_ykgwfile_determine_calib(ykgwfile, meg_info)
% set calibration information into meg_info
%
% [usage]
%   [meg_info] = vb_ykgwfile_determine_calib(ykgwfile, meg_info)
%
% [input]
%   ykgwfile : <required> <<file>> data file path
%   meg_info : <optional> <<struct>> base of information
%            :  if this is not specified or is empty, meg_info will be created 
%            :  newly
%
% [output]
%   meg_info : <<struct>> updated meg_info
%
% [note]
%   change sensor_gain size from only active_ch to all
%
%   See also
%     getYkgwHdrCalib
%
% [history]
%   2007-06-28 (Sako) initial version
%   2011-06-24 (Sako) modified to use the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ykgwfile', 'var'), ykgwfile = ''; end
if ~exist('meg_info', 'var'), meg_info = []; end
% [meg_info, fid] = inner_check_arguments(ykgwfile, meg_info);
[ykgwfile, meg_info] = inner_check_arguments(ykgwfile, meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
%
% -- Calibration information
%
calib_info = getYkgwHdrCalib(ykgwfile);
meg_info.sensor_gain   = [calib_info.sensitivity(:).gain]';
meg_info.sensor_offset = [calib_info.sensitivity(:).offset]';
meg_info.FLL_gain      = [calib_info.fll(:).gain]';

% --- <calib_info>
%       .sensitivity <<struct array>>
%         .gain
%         .offset
%
%       .fll <<struct array>>
%         .gain
%
%       .ad  <<struct>>
%         .bit
%         .analog_range [Volt]

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% function [meg_info, fid] = inner_check_arguments(ykgwfile, meg_info)
function [ykgwfile, meg_info] = inner_check_arguments(ykgwfile, meg_info)
func_ = mfilename;

if isempty(ykgwfile)
  error('(%s)ykgwfile is a required parameter', func_);
end

if isempty(meg_info)
%   error('(%s)meg_info is a required parameter', func_);
end

% check validity as a file
if exist(ykgwfile, 'file') ~= 2
  error('(%s)cannot find yokogawa file : %s', func_, ykgwfile);
end

return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
