function	[bexp] = vb_load_yokogawa_meg_data(megfile)
% !!! DONT USE THIS FUNCTION !!! load MEG data from yokogawa megmat file.
% [usage]
%    [bexp] = vb_load_yokogawa_meg_data(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
% [output]
%      bexp : extracted MEG data [Channel x Sample x Trial]
% [note]
%   you had better use vb_load_meg_data
%   if bexp is empty, try to read data files
% [history]
%   2007-06-20 (Sako) extended the case that loaded bexp is empty
%   2008-06-06 (Sako) added recommended message
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
bexp = vb_load_meg_data(megfile);
% load(megfile, 'bexp'); 
% 
% % --- extended edition --- %
% if isempty(bexp)
%   meginfo = vb_megfile_load_meginfo(megfile);
%   meg_ch_list = vb_meginfo_get_channel_label_meg(meginfo)';
%   
%   loadspec = loadspec_make(true, meg_ch_list);
%   
%   bexp = vb_megfile_load_data(megfile, loadspec);
% end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;
if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
