function	result = vb_check_vivid_marker(marker)
% check Left to Right order of marker
% marker : [5 x 3]
%  Left          Right
%  X:  1 4 3 5 2  -> (X: increase)
%  SPM Right-hand coordinate   
%   X: Left   -> Right
%   Y: Back   -> Front
%   Z: Bottom -> Top
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

result = FAILURE;

% Left to Right order of marker
order = [1 4 3 5 2];
order = order(:);

[N, D] = size(marker);

if D~=3, 
	fprintf('Space dimension %d is not 3\n',D); 
	return
end;

if N~=5, 
	fprintf('Number of marker %d is not 5\n',N); 
	return
end;


[tmp, ix] = sort( marker(:,1));

err = sum(abs(ix - order));

if err > 0,
	fprintf('Left to Right order of marker is unusual\n'); 
	return
end;

result = SUCCESS;
