function [meginfo] = vb_meginfo_set_acqtype(meginfo, acqinfo)
% <<setter>> for acquisition type of MEGinfo
%
% [usage]
%   [meginfo] = vb_meginfo_set_acqtype(meginfo, acqinfo)
%
% [input]
%   meginfo : <required> <<struct>> MEGinfo
%   acqinfo : <optional> <<struct>> or <<string>>
%           :  --- <<struct>> ---
%           :  If acqinfo is struct it is expected to have following fields.
%           :   (must)
%           :   .type
%           :   .type_code
%           :   (following fields are not used here)
%           :   .sample_rate
%           :   .frame_length
%           :   .pretrigger_length
%           :   .num_epoch
%           :   .setup_sample_count
%           :   .trigger_mode
%           :   .trigger_setting
%           :
%           :  --- <<string>> ---
%           :  acquisition type string []
%           :  e.g.
%           :  'Continuous_Raw'
%           :  'Evoked_Ave'
%           :  'Evoked_Raw'
%
% [output]
%   meginfo : MEGinfo after updating
%
% [note]
%   
% [history]
%   2008-02-21 (Sako) initial version
%   2011-05-26 (Sako) modified according to the new data format
%   2011-06-24 (Sako) modified to fit the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('acqinfo', 'var'), acqinfo = []; end
[meginfo, acqinfo] = inner_check_arguments(meginfo, acqinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isstruct(acqinfo)
  % --- <<struct>>
  if isfield(acqinfo, 'type')
    meginfo.device_info.acq_type = acqinfo.type;
  end
  if isfield(acqinfo, 'type_code')
    meginfo.acq_type_code = acqinfo.type_code;
  end
else
  % --- <<string>> = old fashion
  meginfo.device_info.acq_type = acqinfo;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, acqinfo] = inner_check_arguments(meginfo, acqinfo)
func_ = mfilename;

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(acqinfo)
  acqinfo = '';
  % require no action because this will be set as it is empty
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
