function [meg_info] = vb_meginfo_set_acqfile(meg_info, acq_file)
% MEGinfo setter for acquisition file path
% [usage]
%   [meg_info] = vb_meginfo_set_acqfile(meg_info, acq_file)
% [input]
%   meg_info : <optional> <<struct>> MEG information []
%   acq_file : <optional> <<file>> acquisition file path []
% [output]
%   meg_info : updated MEG information struct
%            :  the data is stored in 'acq_info' as 'data_file' field
% [note]
%   if meg_info is empty, this program creates new meg_info
%   The new standard format was defined. (2011-05)
% [history]
%   2007-06-12 (Sako) initial version
%   2008-01-31 (Sako) modified slightly
%   2011-05-26 (Sako) modified according to the new format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('acq_file', 'var'), acq_file = []; end
[meg_info, acq_file] = inner_check_arguments(meg_info, acq_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg_info.device_info.acq_info.data_file = acq_file;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, acq_file] = inner_check_arguments(meg_info, acq_file)

if isempty(meg_info)
  meg_info.acq_info = [];
end

if isempty(acq_file)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
