function [meg_info] = vb_meginfo_set_acqcond(meg_info, acq_cond)
% MEGinfo setter for acquisition condition
% [usage]
%   [meg_info] = vb_meginfo_set_acqcond(meg_info, acq_cond)
% [input]
%   meg_info : <required> <<struct>> MEG information
%   acq_cond : <optional> if this is not specified, set empty
% [output]
%   meg_info : updated MEG information struct
%            :  acq_cond data is stored as device_info.acq_info.condition
% [note]
%   example of acq_cond)
%                   type: 'Continuous_Raw'
%            sample_rate: 4500
%           frame_length: 1710000
%      pretrigger_length: []
%              num_epoch: 1
%     setup_sample_count: []
%           trigger_mode: []
%        trigger_setting: []
% [history]
%   2011-05-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('acq_cond', 'var'), acq_cond = []; end
[meg_info, acq_cond] = inner_check_arguments(meg_info, acq_cond);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg_info.device_info.acq_info.condition = acq_cond;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, acq_cond] = inner_check_arguments(meg_info, acq_cond)
func_ = mfilename;

if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
