function [freq] = vb_meginfo_get_sampling_frequency(meginfo)
% return sampling frequency from MEGinfo struct
%
% [usage]
%   [freq] = vb_meginfo_get_sampling_frequency(meginfo)
%
% [input]
%   meginfo : <required> <<struct>> MEG header information
%
% [output]
%      freq : value of sampling frequency
%
% [note]
%   
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
freq = meginfo.SampleFreq;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [meginfo] = inner_check_arguments(meginfo)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'SampleFreq')
  meginfo.SampleFreq = 0;
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
