function [pretrigger] = vb_meginfo_get_pre_trigger(MEGinfo)
% return pre-trigger from current MEGinfo struct
% [usage]
%   [pretrigger] = vb_meginfo_get_pre_trigger(MEGinfo)
% [input]
%      MEGinfo : <required> <<struct>> MEG information
% [output]
%   pretrigger : pre-trigger value of current MEGinfo
% [note]
%   incorrect spelling 'Pretriger'
%   if given MEGinfo does not have the appropriate field, return empty [].
% [hisotory]
%   2007-06-29 (Sako) initial version
%   2007-08-02 (Sako) rename function name from 'pretrigger' to 'pre_trigger'
%   2008-01-29 (Sako) renewed due to new specification
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('MEGinfo', 'var'), MEGinfo = []; end
[MEGinfo] = inner_check_arguments(MEGinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
pretrigger = [];

if isfield(MEGinfo, 'Pretriger')
  pretrigger = MEGinfo.Pretriger;
elseif isfield(MEGinfo, 'Pretrigger')
  pretrigger = MEGinfo.Pretrigger;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [MEGinfo] = inner_check_arguments(MEGinfo)

func_ = mfilename;
if isempty(MEGinfo)
  error('(%s)MEGinfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
