function [bit_len] = vb_meginfo_get_data_bit_len(meg_info)
% MEGinfo getter for data bit length
%
% [usage]
%   [bit_len] = vb_meginfo_get_data_bit_len(meg_info)
%
% [input]
%   meg_info : <required> <<struct>> MEG header information
%
% [output]
%    bit_len : data bit length
%
% [note]
%   if the given meg_info does not have an appropriate field, return empty
%   The new standard format is defined. (2011-05)
%
% [history]
%   2007-06-12 (Sako) initial version
%   2011-05-26 (Sako) modified according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
bit_len = [];
if isfield(meg_info, 'device_info')
  if isfield(meg_info.device_info, 'acq_info')
    if isfield(meg_info.device_info.acq_info, 'data_bit_len')
      bit_len = meg_info.device_info.acq_info.data_bit_len;
    else
%       warning('device_info.acq_info does not have ''data_bit_len'' field\n');
    end
  else
%     warning('device_info does not have ''acq_info'' field\n');
  end
else
  if isfield(meg_info, 'acq_info')
    if isfield(meg_info.acq_info, 'data_bit_len')
      bit_len = meg_info.acq_info.data_bit_len;
    else
%       warning('acq_info does not have ''data_bit_len'' field\n');
    end
  else
%     warning('meg_info does not have ''acq_info'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
