function Nchannel = vb_meginfo_get_channel_number_whole(meginfo, active_swt)
% get number of whole channel from MEGinfo struct and return it
% [usage]
%   Nchannel = vb_meginfo_get_channel_number_whole(meginfo)
% [input]
%      meginfo : <required> <<struct>> MEG information
%   active_swt : <optional> <<boolean>> [false]
%              :  switch to return whether all the channels or only active
%              :   true) only active channels
%              :  false) all the channels
% [output]
%     Nchannel : number of whole channel
% [note]
%   
% [history]
%   2007-06-28 (Sako) initial version
%   2008-02-08 (Sako) modified according to new spec
%   2008-05-01 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meginfo, active_swt] = inner_check_arguments(meginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Nchannel_meg = vb_meginfo_get_channel_number_meg(meginfo, active_swt);
Nchannel_ext = vb_meginfo_get_channel_number_extra(meginfo, active_swt);
Nchannel_ref = vb_meginfo_get_channel_number_refmg(meginfo, active_swt);
Nchannel = Nchannel_meg + Nchannel_ext + Nchannel_ref;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, active_swt] = inner_check_arguments(meginfo, active_swt)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
