function [idx, result] = ...
  vb_meginfo_get_channel_index_refmg(meg_info, ch_name, active_swt)
% <getter> return reference channel's index in extra channel list
% [usage]
%   [idx, result] = ...
%      vb_meginfo_get_channel_index_refmg(meg_info, ch_name, active_swt)
% [input]
%     meg_info : <required> <<struct>> MEGinfo
%              :  which is expected to have ExtraChannelInfo
%      ch_name : <optional> {Nch x 1 cell} channel name list ['']
%              :  if this is empty, return current reference channel id
%              :  if this is not empty, return specified index of original
%   active_swt : <optinal> <<boolean>> [false] switch to filter active channels
%              :   true) only active channels
%              :  false) active filter does not have effect
% [output]
%          idx : index list of channels [N x 1]
%       result : <<integer>> error code
%              :  0) success
%              :  1) error - bad MEGinfo
% [note]
%   for only YOKOGAWA now
%   if device is not YOKOGAWA, return empty array
% [history]
%   2007-06-29 (Sako) initial version
%   2008-02-21 (Sako) thoroughly modified according to new specification
%   2008-04-21 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('ch_name', 'var'), ch_name = ''; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meg_info, ch_name, active_swt, result] = ...
  inner_check_arguments(meg_info, ch_name, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
idx = [];

if result ~= 0
  return;
end

if ~strcmp('YOKOGAWA', vb_meginfo_get_device(meg_info))
  return;
end

if isempty(ch_name);
  all_idx = vb_meginfo_get_channel_id_extra(meg_info);
  all_tps = vb_meginfo_get_channel_type_extra(meg_info);
  % in YOKOGAWA data, types over zero mean reference
  idx = all_idx(all_tps > 0);
else
  % get labels of all the channels
  all_idx = vb_meginfo_get_channel_id_extra(meg_info);
  all_label = vb_meginfo_get_channel_label_extra(meg_info, false, true);
  all_label_ref = vb_meginfo_get_channel_label_refmg(meg_info, active_swt);

  [ref_label_idx] = vb_util_get_index(all_label_ref, ch_name);
  target_label = all_label_ref(ref_label_idx);
  
  [label_idx] = vb_util_get_index(all_label, target_label);
  idx = all_idx(label_idx);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, ch_name, active_swt, result] = ...
  inner_check_arguments(meg_info, ch_name, active_swt)
func_ = mfilename;
result = 0;

if isempty(meg_info)
  fprintf('(%s)meg_info is a required parameter\n', func_);
  result = 1;
  return;
end

if ~isfield(meg_info, 'ExtraChannelInfo')
  fprintf('(%s)meg_info does not have ExtraChannelInfo field\n', func_);
  result = 1;
  return;
end

if ~isempty(ch_name) && ~iscell(ch_name)
  ch_name = {ch_name};
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
