function [idx, ch_name_idx] = ...
  vb_meginfo_get_channel_index_meg(meginfo, ch_name, active_swt)
% <getter> MEGinfo return channel index of MEG
% [usage]
%   [idx, ch_name_idx] = ...
%     vb_meginfo_get_channel_index_meg(meginfo, ch_name, active_swt)
% [input]
%   meginfo : <required> <<struct>> MEGinfo
%   ch_name : <optional> {Nch x 1 cell} channel name list ['']
%           :  if this is empty, return current MEGch_id
%           :  if this is not empty, return specified index of original
%   active_swt : <optional> <<boolean>> active filter switch [false]
%              :   true) filter active channels
%              :  false) all the channels
% [output]
%           idx : [N_sameCh x 1] index of MEG channel
%   ch_name_idx : [N_sameCh x 1] index of ch_name
% [note]
%
% [history]
%   2008-02-21 (Sako) initial version
%   2008-04-15 (Sako) added active_flag as return
%   2008-08-25 (Sako) changed interface - added active_swt
%   2009-06-25 (Sako) added return value "ch_name_idx"
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('ch_name', 'var'), ch_name = ''; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meginfo, ch_name, active_swt] = ...
  inner_check_arguments(meginfo, ch_name, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
active_list = vb_meginfo_get_channel_active_meg(meginfo, active_swt);

if isempty(ch_name)
  idx = meginfo.MEGch_id;
  ch_name_idx = [];
else
  % ----- get all the channel label of MEG
  ch_label = vb_meginfo_get_channel_label_meg(meginfo, false);
  if ~isempty(ch_label)
    [ch_idx] = vb_util_get_index(ch_label, ch_name);
    a_list = find(active_list == 1);
    [alist_idx,ch_name_idx] = vb_util_get_index(a_list, ch_idx);
    idx = a_list(alist_idx);
  else
    idx = [];
    ch_name_idx = [];
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [meginfo, ch_name, active_swt] = ...
  inner_check_arguments(meginfo, ch_name, active_swt)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'MEGch_id')
  meginfo.MEGch_id = [];
end

if isempty(ch_name)
  % require no action
elseif ~iscell(ch_name)
  ch_name = {ch_name};
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
