function [active_list, result] = ...
  vb_meginfo_get_channel_active_extra(meg_info, active_swt)
% return active list of extra channels
% [usage]
%   [active_list, result] = ...
%     vb_meginfo_get_channel_active_extra(meg_info, active_swt)
% [input]
%      meg_info : <required> <<struct>> MEGinfo which has 'ExtraChannelInfo'
%    active_swt : <optional> <<boolean>> active filter switch [true]
%               :   true) return as it is
%               :  false) return all one list
% [output]
%   active_list : ExtraChannelInfo.Channel_active
%        result : <<integer>> error code
%               :  0) success
%               :  1) error - bad MEGinfo
% [note]
%   return value includes reference channels if exist
% [history]
%   2008-04-17 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meg_info, active_swt, result] = inner_check_arguments(meg_info, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
active_list = [];
if result ~= 0
  return;
end

if ~isfield(meg_info.ExtraChannelInfo, 'Channel_active')
  active_list = [];
  return;
else
  active_list = meg_info.ExtraChannelInfo.Channel_active;
  if ~active_swt
    % convert all elments one
    active_list = ones(length(active_list),1);
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, active_swt, result] = ...
  inner_check_arguments(meg_info, active_swt)
func_ = mfilename;
result = 0; % success

if isempty(meg_info)
  fprintf('(%s)meg_info is a required parameter\n', func_);
  result = 1;
  return
end

if ~isfield(meg_info, 'ExtraChannelInfo')
  fprintf('(%s)meg_info must have ExtraChannelInfo field\n', func_);
  result = 1;
  return;
end

if isempty(active_swt)
  active_swt = true;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
