function [calib_info] = vb_meginfo_get_calibinfo( meg_info )
% return CalibInfo struct from MEGinfo for calibration
%
% [usage]
%   [calib_info] = vb_meginfo_get_calibinfo( meg_info )
%
% [input]
%     meg_info : <required> which must have a "CalibInfo" field
%              :  If this is empty or invalid (which does not have CalibInfo
%              :  field etc), return empty.
%
% [output]
%   calib_info : <<struct>> meg_info.CalibInfo as it be
%              :  .channel_id    [n_channel x 1]
%              :  .sensor_gain   [n_channel x 1]
%              :  .sensor_offset [n_channel x 1]
%              :  .FLL_gain      [n_fll x 1]
%              :  .data_bit_len  [1 x 1]
%              :  .analog_range  [1 x 1] [VOLT]
%
% [note]
%   The meg_info.calib_info is different from the original calib_info 
%   loaded by getYkgwHdrCalib function.
%
% [history]
%   2011-07-08 (Sako) initial version

if ~exist('meg_info', 'var'), meg_info = []; end

calib_info = [];

if isempty(meg_info), return; end
if ~isfield(meg_info, 'CalibInfo') || isempty(meg_info.CalibInfo)
  return;
end
calib_info = meg_info.CalibInfo;
return;

% --- END OF FILE --- %
