function [result, Nsample] = vb_meginfo_check_sample(meginfo, ...
  sample_from, sample_to)
% check sample information (from, to)
%
% [usage]
%   [result, Nsample] = vb_meginfo_check_sample(meginfo, sample_from, sample_to)
%
% [input]
%       meginfo : <required> <<struct>> MEG header information
%   sample_from : <required> start sample number
%     sample_to : <required> end sample number
%
% [output]
%        result : boolean
%               :   true : both sample_from and sample_to are valid
%               :  false : out of sample
%       Nsample : number of sample
%
% [note]
%   if sample_from or sample_to is out of sample, this function outputs
%   warning message.
%
% [history]
%   2007-06-20 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var') meginfo = []; end
if ~exist('sample_from', 'var') sample_from = []; end
if ~exist('sample_to', 'var') sample_to = []; end
[meginfo, sample_from, sample_to] = ...
  inner_check_arguments(meginfo, sample_from, sample_to);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = 'vb_meginfo_check_sample';

result = true;

Nsample = vb_meginfo_get_sample_number(meginfo);

% --- check sample_from
if sample_from < 1 || Nsample < sample_from
  result = false;
  warning('(%s)sample_from is out of sample : %d (Nsample is %d)', ...
    func_, sample_from, Nsample);
end

% --- check sample_to
if sample_to < 1 || Nsample < sample_to
  result = false;
  warning('(%s)sample_to is out of sample : %d (Nsample is %d)', ...
    func_, sample_to, Nsample);
end

% --- check sample_from and sample_to
if sample_to < sample_from
  result = false;
  warning('(%s)sample_to (%d) is smaller than sample_from (%d)', ...
    func_, sample_to, sample_from);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, sample_from, sample_to] = ...
  inner_check_arguments(meginfo, sample_from, sample_to)

func_ = 'vb_meginfo_check_sample';

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(sample_from)
  error('(%s)sample_from is a required parameter', func_);
end

if isempty(sample_to)
  error('(%s)sample_to is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
