function vb_megfile_set_spherical_data( meg_file, sph_data )
% set spherical data (Vcenter, Vradius) to a .meg.mat file
% [usage]
%   vb_megfile_set_spherical_data( meg_file, sph_data )
% [input]
%   meg_file : <required> <<file>> updated file
%   sph_data : <required> <<struct>> data of spherical model
%               following fields are required.
%               .Vcenter : (x,y,z) center coordinate of the spherical model
%               .Vradius : [m] radius of the spherical model
% [output]
%   none
% [note]
%   updated fields are MEGinfo.Vcenter and MEGinfo.Vradius
% [history]
%   2011-05-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_file', 'var'), meg_file = ''; end
if ~exist('sph_data', 'var'), sph_data = []; end
[meg_file, sph_data] = inner_check_arguments(meg_file, sph_data);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg = load(meg_file);
if isfield(sph_data, 'Vcenter')
  meg.MEGinfo.Vcenter = sph_data.Vcenter;
end
  
if isfield(sph_data, 'Vradius')
  meg.MEGinfo.Vradius = sph_data.Vradius;
end

vb_save_struct(meg_file, meg);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_file, sph_data] = inner_check_arguments(meg_file, sph_data)
func_ = mfilename;

if isempty(meg_file)
  error('(%s) meg_file is a required parameter', func_);
end
if exist(meg_file, 'file') ~= 2
  error('(%s) cannot be found meg_file : %s', func_, meg_file);
end

if isempty(sph_data)
  error('(%s) sph_data is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %


