function [ch_list] = vb_ch_info_get_channel_list_ext(ch_info)
% <<private>> return list of EXTRA channel from ch_info
% [usage]
%   [ch_list] = vb_ch_info_get_channel_list_ext(ch_info)
% [input]
%   ch_info : <required> <<struct>> temporal channel information
% [output]
%   ch_list : list of EXTRA channel which ch_info has [N x 1]
% [note]
%   if ch_info is not specified or is empty, this function returns empty
% [history]
%   2007-07-12 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ch_info', 'var') ch_info = []; end
[ch_info] = inner_check_arguments(ch_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
ch_list = [];

if ~isempty(ch_info) && isfield(ch_info, 'ext_channel')
  ch_list = ch_info.ext_channel;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ch_info] = inner_check_arguments(ch_info)
func_ = mfilename;
if isempty(ch_info)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
