function	Data = vb_read_stylus(fname)
% Read FastScan point data file
%  Data = read_stilus(fname)
% Data  : point coordinate [Npoint 3]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

key  = '%';

% Find keyward line
fid=fopen(fname);

if fid == -1, fprintf('[%s] can not be opened\n',fname);return; end;

Nline = 0;

while 1
    next_line = fgetl(fid);
    if ~ischar(next_line), break, end;
	if isempty( strfind(next_line,key)), break, end;
    Nline=Nline+1;
end

fclose(fid);

fid=fopen(fname);

for n = 1:Nline
    next_line = fgetl(fid);
end

% from here on it's just data

Data = fscanf(fid,'%f',Inf);

fclose(fid);

[N M] = size(Data);
Ndata = N*M/6;

Data = reshape(Data, [6 Ndata]);
Data = Data';
Data = Data(:,1:3);

