function    [marker, marker_name, ch_pos, ch_name] = vb_load_itk(fname)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Read itk-file for 3D-digitizer IISOTRAK
%
% marker     : reference position         (3 x 3)
% marker(1,:): Left PA position (x,y,z)
% marker(2,:): Nasion
% marker(3,:): Right PA position
%
% marker_name: marker name            (3 x 1)
% ch_pos     : channel position       (Nchannel x 3)
% ch_name    : channel name           (Nchannel x 1)
% written by Hiroe 2005.11.1


marker = [];
marker_name = cell(3,1);
ch_pos = [];
ch_name = [];

fid = fopen(fname,'r');

if fid == -1
    error('file open error')
end

k = 0;
flg = true;

while ( flg == true )
    line = fgets(fid);  %%% read one line %%%
    
    if line == -1
        flg = false;
        break;

    elseif ~isempty(deblank(line)) % null line check
        [name, pos(1), pos(2), pos(3)] = strread(line, '%s%f%f%f');

        switch( char(name) )
            case 'LPA'
                marker(1,:) = pos(:)';
                marker_name(1,1) =name;
            case 'Nasion'
                marker(2,:) = pos(:)';
                marker_name(2,1) = name;
            case 'RPA'
                %r_b = pos;
                marker(3,:) = pos(:)';
                marker_name(3,1) = name;
            otherwise
                k = k+1;
                ch_pos(k, :) = pos(:)';
                ch_name = [ch_name; name];
        end
    end
end
% end of while 

fclose(fid);

