function [eeginfo] = vb_eeginfo_set_version(eeginfo, version)
% set version data to EEGinfo
% [usage]
%   [eeginfo] = vb_eeginfo_set_version(eeginfo, version)
% [input]
%   eeginfo : <required> <<struct>> EEGinfo
%   version : <optional> <<string>> version data []
% [output]
%   eeginfo : updated EEGinfo
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('version', 'var'), version = ''; end
[eeginfo, version] = inner_check_arguments(eeginfo, version);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo.device_info.Version = version;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, version] = inner_check_arguments(eeginfo, version)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s) eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
