function [Nch] = vb_eeginfo_get_sensor_number(eeginfo, active_swt)
% return number of sensor
% [usage]
%   [Nch] = vb_eeginfo_get_sensor_number(eeginfo, active_swt)
% [input]
%      eeginfo : <required> <<struct>> EEGinfo which includes Coord
%   active_swt : <optional> <<boolean>> [false]
%              :  switch to return whether all the channels or only active
%              :   true) only active channels
%              :  false) all the channels
% [output]
%          Nch : number of used channels
% [note]
%
% [history]
%   2008-05-01 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
sensor_pos = vb_eeginfo_get_sensor_position(eeginfo, active_swt);
Nch = size(sensor_pos, 1);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end

if ~isfield(eeginfo, 'Coord')
  eeginfo.Coord = [];
end

if isempty(active_swt)
  active_swt = false;
end
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
