function [header] = vb_eeginfo_get_header(eeginfo)
% return header data of Biosemi from EEGinfo
%
% [usage]
%   [header] = vb_eeginfo_get_header(eeginfo)
%
% [input]
%    eeginfo : <required> <<struct>> EEGinfo
%
% [output]
%     header : <<struct>> header information of Biosemi
%
% [note]
%   device dependent data
%
%   Fields are as follows:
%   ========= EEGinfo.Header ==========
%            FILE:
%        FileName: 
%         VERSION: 
%             PID: 
%             RID: 
%              T0: 
%         HeadLen: 
%            NRec: 
%             Dur: 
%              NS: 
%           Label: 
%      Transducer: 
%         PhysDim: 
%         PhysMin: 
%         PhysMax: 
%          DigMin: 
%          DigMax: 
%         PreFilt: 
%             SPR: 
%             Cal: 
%             Off: 
%           Calib: 
%      SampleRate: 
%     Chan_Select: 
%         ChanTyp: 
%              AS: 
% 
% [history]
%   2008-02-27 (Sako) initial version
%   2011-05-27 (Sako) modified according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
header = [];

if isfield(eeginfo, 'device_info')
  if isfield(eeginfo.device_info, 'Header')
    header = eeginfo.device_info.Header;
  else
%     warning('device_info does not have ''Header'' field\n');
  end
else
  if isfield(eeginfo, 'Header')
    header = eeginfo.Header;
  else
%     warning('eeginfo does not have ''Header'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
