function [data_dir] = vb_eeginfo_get_datadir(eeginfo)
% <<getter>> return binary data directory from EEGinfo
% [usage]
%   [data_dir] = vb_eeginfo_get_datadir(eeginfo)
% [input]
%   eeginfo : <required> <<struct>> EEGinfo
% [output]
%   data_dir : data directory
% [note]
% 
% [history]
%   2008-02-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(eeginfo, 'File') || ~isfield(eeginfo.File, 'DataDir')
  data_dir = '.';
else
  data_dir = eeginfo.File.DataDir;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
