function [ch_list] = vb_eeginfo_get_channel_label(eeginfo, active_swt)
% return channel label list from EEGinfo struct
% [usage]
%   [ch_list] = vb_eeginfo_get_channel_label(eeginfo, active_swt)
% [input]
%      eeginfo : <required> <<struct>> EEGinfo
%   active_swt : <optional> <<boolean>> [false]
%              :   true) return only active channels (EEG)
%              :  false) return all the channels (EEG)
% [output]
%      ch_list : valid channel label list
% [note]
%   .ChannelName field keeps eeg sensor channel, not extra channels
% [history]
%   2008-02-26 (Sako) initial version
%   2008-04-14 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(eeginfo, 'ChannelName')
  ch_list = [];
  return;
else
  ch_list = eeginfo.ChannelName;
end

if ~active_swt
  return;
end

active_list = vb_info_get_active_channel(eeginfo);

if length(active_list) ~= length(ch_list)
  fprintf('(%s) different length - active list and channel list\n', ...
    mfilename);
  return;
end
ch_list = ch_list(active_list == 1);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end

if ~vb_info_active_channel_is_valid(eeginfo)
  active_swt = false;
elseif isempty(active_swt)
  active_swt = false;
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
