function new_EEGinfo = vb_eeginfo_add_history(EEGinfo, this_history)
% add history information to EEGinfo
% [usage]
%   new_EEGinfo = vb_eeginfo_add_history(EEGinfo, this_history)
% [input]
%        EEGinfo : <required> EEGinfo that will be updated
%   this_history : <required> added story of execution (string)
% [output]
%   new_EEGinfo : new EEGinfo
% [note]
%   
% [history]
%   2006-11-22 (Sako) initial version
%   2011-05-27 (Sako) modified according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vb_define_device;

% --- CHECK ARGUMENT --- %
if ~exist('EEGinfo', 'var'), EEGinfo = []; end
if ~exist('this_history', 'var'), this_history = []; end
[EEGinfo, this_history] = inner_check_argument(EEGinfo, this_history);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(this_history)
  % do nothing
  return;
end

new_EEGinfo = EEGinfo;
new_history = sprintf('[%s] %s', datestr(now), this_history);

if isfield(new_EEGinfo, 'device_info')
  if ~isfield(new_EEGinfo.device_info, 'History')
    his_len = 0;
  else
    his_len = size(new_EEGinfo.device_info.History, 2);
  end
end
new_EEGinfo.device_info.History{his_len+1} = new_history;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_argument()
%
function [EEGinfo, this_history] = inner_check_argument(EEGinfo, this_history)
func_ = mfilename;
if isempty(EEGinfo)
  error('(%s)EEGinfo is required', func_);
end
return;
%
% --- end of inner_check_argument()

%--- END OF FILE ---%
