function [freq] = vb_eegfile_get_sampling_frequency(eegfile)
% return valid sampling frequency from EEG-MAT file
% [usage]
%   [channel_list] = vb_eegfile_get_sampling_frequency(eegfile)
% [input]
%   eegfile : <required> <<file>> EEG-MAT file (*.eeg.mat)
% [output]
%      freq : value of sampling frequency
% [note]
%   @see vb_eeginfo_get_sampling_frequency.m
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eegfile', 'var') eegfile = []; end
[eegfile] = inner_check_arguments(eegfile);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo = vb_eegfile_load_eeginfo(eegfile);
freq = vb_eeginfo_get_sampling_frequency(eeginfo);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eegfile] = inner_check_arguments(eegfile)
func_ = mfilename;
if isempty(eegfile)
  error('(%s)eegfile is a required parameter', func_);
end

if exist(eegfile, 'file') ~= 2
  error('(%s)cannot find eegfile : %s', func_, eegfile);
end
return;
%
% --- end of inner_check_arguments()

% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
