function [ChannelLabel, RecordTime, Nch, SampleRate, data_type, ...
  PhysicalUnit, DAT] = vb_bdffile_get_info(bdf_file)
% read BDF file
% [usage]
%   [ChannelLabel, RecordTime, Nch, SampleRate, data_type, ...
%     PhysicalUnit, DAT] = vb_bdffile_get_info(bdf_file)
% [input]
%   bdf_file : <required> <<file>> BDF file
% [output]
%   ChannelLabel : {1,Nch} list of channel name
%     RecordTime : [Sec] record time
%            Nch : number of channel
%     SampleRate : [Hz] sample frequency
%      data_type : data type ['float32']
%   PhysicalUnit : physical unit of data {1 x n_channel}
%            DAT : <<struct>> original data set which includes header (.Head)
% [note]
%   The detail of header are beyond the scope
% [history]
%   2008-03-31 (Sako) initial version
%   2009-12-25 (Sako) added PhysicalUnit to the return values
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('bdf_file', 'var'), bdf_file = ''; end
[bdf_file] = inner_check_arguments(bdf_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
vb_define_device;

[DAT,H1] = vb_openbdf(bdf_file);
% --- H1 is not used now

% procedure parameters
header     = DAT.Head;
RecordTime = header.NRec;
Nch        = header.NS;
SampleRate = max(header.SampleRate);
data_type  = STANDARD_BIN_DATA_TYPE;
% data_size  = STANDARD_BIN_DATA_SIZE;

ChannelLabel = cell(1,Nch);
PhysicalUnit = cell(1,Nch);

% get channel label for hardware
for ch = 1:Nch
  ChannelLabel{ch} = deblank(header.Label(ch,:));
  PhysicalUnit{ch} = deblank(header.PhysDim(ch,:));
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [bdf_file] = inner_check_arguments(bdf_file)
func_ = mfilename;
if isempty(bdf_file)
  error('(%s)bdf_file is a required parameter', func_);
end

if exist(bdf_file, 'file') ~= 2
  error('(%s)cannot find bdf_file: %s', func_, bdf_file);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
