function	vb_save_active_info(fileinfo, outfile, cond_list, session_no)
% Save active info for multiple session file data
%   vb_save_active_info(fileinfo, outfile, cond_list, session_no)
% --- Input 
% fileinfo : file information for multiple session files
% outfile  : Output file name (saved variable : 'fileinfo')
% --- Optional Input 
% cond_list  : list of condition number to select
%              if empty, all conditions are selected
% session_no : session number to select
%              if empty, all sessions are selected
% 
% --- Saved variable
% fileinfo : structure with file information for multiple files
% fileinfo.filename{n}  : n-th session data file names [n=1:Nsession]
% fileinfo.Nchannel     : # of total channels
% fileinfo.Nsample      : # of samples in one trial
% fileinfo.Ntotal       : # of all trials 
% fileinfo.Ntrial       : # of trials for each session [1 x Nsession]
% fileinfo.session_id   : session index for each trial [1 x Ntotal]
% fileinfo.cond_id      : condition number for each trials [1 x Ntotal]
% fileinfo.ActiveChannel: Active channel list (boolean array) [Nchannel x 1]
% fileinfo.ActiveTrial  : Active trial list   (boolean array) [Ntotal x 1]
%
% Masa-aki Sato 2008-8-10
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 2, 
	help vb_save_active_info
	error('Input argument error'); 
end;

if nargin < 3, cond_list  = [];end
if nargin < 4, session_no = [];end

%if ~exist('cond_list','var'), cond_list = []; end;
%if ~exist('session_no','var'), session_no = []; end;

% select condition & session
fileinfo = vb_get_active_cond(fileinfo,cond_list,session_no);

Measurement = 'INFO';

fprintf('Total %d channel & %d epoch\n',fileinfo.Nchannel, fileinfo.Ntotal)
if isfield(fileinfo, 'channel_id')
    fprintf('Good  %d channel & %d epoch\n',...
	    length(fileinfo.channel_id), length(fileinfo.act_trial));
else
    fprintf('Good  %d channel & %d epoch\n',...
	    length(find(fileinfo.ActiveChannel==1)), length(find(fileinfo.ActiveTrial==1)));
end
fprintf('Save active info to: \n%s\n',outfile)

vb_fsave(outfile, 'fileinfo','Measurement');
