function	[ylist,h,yy] = vb_plot_stat_hist(y,plist)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

N = length(plist);
[Nch, Ntry] = size(y);
Nbin = 500;
ymax = max(y(:));

[h, yy] =hist(y(:),Nbin);

[ylist, p] = vb_find_hist_threshold(h,yy,plist);

ylist = [ylist, ymax];

% sum( pd * dy) = 1
dy = yy(2) - yy(1);
pd = p / dy;

plot(yy,pd);

hold on
type  = {'r--', 'b--', 'm--', 'c--'};

for n=1:N-1
	plot([ylist(n) ylist(n)],[0 max(pd)], type{n})
end

xlim([0 ylist(N)])
