function	vb_plot_max_ratio_image(ratio,thred_val,thred_max)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% candidate of threshold value
if nargin < 2, thred_val = [5:10]; end;
% max of threshold value
if nargin < 3, thred_max = max(thred_val) + 0.1;end; 

Nthre = length(thred_val);

[Nch, Ntry] = size(ratio);

% limit max value for image plot
ratio = min(ratio,thred_max);

% plot bad channel & trial in 2D image (# of threshold = 1)
if Nthre==1,
	ratiov = zeros(Nch, Ntry);
	
	ix = find(ratio > thred_val);
	ratiov(ix) = ratio(ix);
	
	image(ratiov, 'CDataMapping','scaled');
	xlabel('Trials')
	ylabel('Channels')
	return
end

% plot bad channel & trial in 2D image (# of threshold > 1)
NYfig=2; 
NXfig=ceil(Nthre/NYfig);
nfig = 1;
figure;

for n=1:Nthre
	subplot(NYfig,NXfig,nfig); nfig = nfig + 1;
	ratiov = zeros(Nch, Ntry);
	
	ix = find(ratio > thred_val(n));
	ratiov(ix) = ratio(ix);
	
	image(ratiov, 'CDataMapping','scaled');
	title(sprintf('Threshold=%5.1f',thred_val(n)))
end

subplot(NYfig,NXfig,NXfig+1); 
xlabel('Trials')
ylabel('Channels')

