function	ch_list = vb_plot_bad_channel(data,ix_ch,flg)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NXfig=2; NYfig=4; 
nfig = 0;
pfig = 1;
print_mode = 0;
basename = 'bad_ch';
ymax = 100;

%[Nch, T, Ntry] = size(data);

% Find Bad Channel with large max_ratio
Nbad  = length(ix_ch);

dtitle = 'Input bad channel numbers';
prompt = {'Bad channel numbers'};

% List of bad Channel
ch_list = [];
ch_temp = [];

figure;

for n=1:Nbad
	nch = ix_ch(n);
	ch_temp = [ch_temp; nch];
	
	nfig = nfig + 1; subplot(NYfig,NXfig,nfig); 

	id = find(flg(nch,:) > 0);
	y  = data(nch,:,id);
	plot(y(:))
	xlim([0 length(y(:))])
	ylim([-ymax ymax])
	title(sprintf('Ch = %d',nch))

	if nfig ==NXfig*NYfig | n==Nbad, 
		if print_mode==1
			fname = sprintf('%s%d.png',basename,pfig);
			pfig=pfig+1;
			orient landscape
			%orient portrait
			print(gcf,'-dpng',fname)
			clf;
		else
			fmode = menu('All Channels are Bad ?',...
					'YES','NO');
	
			if fmode == 2,
				answer = inputdlg(prompt,dtitle);
				ch_temp = sscanf(answer{1},'%d');
				%ch_temp = vb_setdiff2(ch_temp,ch_good);
			end
			ch_list = [ch_list; ch_temp];
			ch_temp = [];
		end
		clf; nfig=0; 
	end;

end

close

%ch_good = vb_setdiff2([1:Nch],ch_list);

return

answer = '1 2 3';
ch_good = sscanf(answer,'%d')
return
