function	[ymax1,ymax2,ystd1,ystd2] = vb_channel_statics(data,sw)
% Estimate mean amplitude by using histgram (for outlier exclusion)
% and calculate amplitude max to find bad channel & trials
% amplitude max for temporal difference is also calculated
%   [ymax1,ymax2,ystd1,ystd2] = vb_channel_statics(X)
% X(ch,t,n)  : signal for ch-th channel at time t & n-th trial
% ymax1(ch,n) : amplitude max for each channel & trial
%             = max_t (abs(X(ch,t,n))) 
% ymax2(ch,n) :amplitude max of temporal difference
% ystd1   : mean amplitude  (: sqrt(<X(t)^2>))
% ystd2   : mean difference (: sqrt(<dX(t)^2>))
% 
% 2008-6-1 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch, T, Ntry] = size(data);

% first order difference on DIM=2 (time)
ydif = abs(diff(data,1,2));

ymax1 = zeros(Nch, Ntry);
ymax2 = zeros(Nch, Ntry);

ystd1 = zeros(Nch, Ntry);
ystd2 = zeros(Nch, Ntry);

if nargin==1, sw = 1; end;

switch	sw
case	1
	for n=1:Nch
		[ymax1(n,:), ystd] = ...
			vb_get_max_std_ratio(squeeze(data(n,:,:)));
		ystd1(n,:) = ystd;
		
		[ymax2(n,:), ystd] = ...
			vb_get_max_std_ratio(squeeze(ydif(n,:,:)));
		ystd2(n,:) = ystd;
	end
case	2
	for n=1:Nch
		[ymax1(n,:), ystd1(n,:)] = ...
			vb_get_max_med_ratio(squeeze(data(n,:,:)));
	
		[ymax2(n,:), ystd2(n,:)] = ...
			vb_get_max_med_ratio(squeeze(ydif(n,:,:)));
	end
end
%ratio = max(ratio1,ratio2);

return
%%% END %%%


xlist = 2:0.1:15;
Nhist = length(xlist);


rmax1 = zeros(Nch, Ntry);
rmax2 = zeros(Nch, Ntry);

rhist1 = zeros(1,Nhist);
rhist2 = zeros(1,Nhist);

yrate1 = zeros(Nch,1);
yrate2 = zeros(Nch,1);

subplot(NY,NX,nfig); nfig = nfig + 1;
plot(ystd1)
%plot(yrate1)
hold on
xlim([0 Nch])
plot(ystd2,'-r')
%plot(yrate2,'-r')

title('Mean amplitude for each channel')


return


NX=2;NY=2;
nfig = 1;
for n=1:NY
	subplot(NY,NX,nfig); nfig=nfig+1;
	plot(xh(:,n),yh(:,n))
	hold on
	plot([ymax(n) ymax(n)],[0 yh(1,n)],'-r')
	plot([ymed(n) ymed(n)],[0 yh(1,n)],'-b')
	
	subplot(NY,NX,nfig); nfig=nfig+1;
	plot(xd(:,n),yd(:,n))
	hold on
	plot([dmax(n) dmax(n)],[0 yd(1,n)],'-r')
	plot([dmed(n) dmed(n)],[0 yd(1,n)],'-b')
end
