function [prec] = vb_saveman_get_precision(saveman)
% return precision from <<struct>> saveman
% [usage]
%   [dtype] = vb_saveman_get_precision(saveman)
% [input]
%   saveman : <required> <<struct>> specification for saving files
% [output]
%      prec : <<string>> precision which was (or will be) used when storing
%           :  e.g. 'float64', 'float32' etc.
% [note]
%   if precision field does not exist, this function return ''(empty string).
% [history]
%   2007-06-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('saveman', 'var'), saveman = []; end
[saveman] = inner_check_arguments(saveman);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
prec = saveman.precision;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [saveman] = inner_check_arguments(saveman)

func_ = 'vb_saveman_get_precision';

if isempty(saveman)
  error('(%s)saveman is a required parameter', func_);
end

% --- check field
if ~isfield(saveman, 'precision')
  % set empty data
  saveman.precision = '';
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
