function [pos, coord_type] = vb_posfile_get_sensorinfo(posfile)
% <<loader>> return sensor position and coordinate types from POS-MAT file
% [usage]
%   [pos, coord_type] = vb_posfile_get_sensorinfo(posfile)
% [input]
%    posfile : <required> <<file>> POS-MAT file
% [output]
%          pos : coordinates of sensor position [Nch x3 double]
%   coord_type : coordinate type before transforming [x1 string]
% [note]
%   now on specify
% [history]
%   2008-02-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('posfile', 'var'), posfile = ''; end
[posfile] = inner_check_arguments(posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
pos = [];
coord_type = '';

load(posfile, 'pos', 'coord_type');
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [posfile] = inner_check_arguments(posfile)
func_ = mfilename;
if isempty(posfile)
  error('(%s)posfile is a required parameter', func_);
end
if exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile : %s', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
