function [new_list,idx] = vb_util_omit_list(base_list, target_list)
% omit string or numerical list from baseline list
% [usage]
%   [new_list,idx] = vb_util_omit_list(base_list, target_list)
% [input]
%     base_list : <required> baseline string list. [Nx1] or [1xN]
%   target_list : <required> target string list to be omitted. [Nx1] or [1xN]
% [output]
%      new_list : new list that is omitted 'target_list' from 'base_list'
%               : [Nx1]
%           idx : indices of base_list
% [note]
%   @see vb_util_arrange_list
% [history]
%   2008-02-27 (Sako) initial version
%   2009-08-10 (Sako) modified the case that new_list is empty
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base_list', 'var'), base_list = []; end
if ~exist('target_list', 'var'), target_list = []; end
[base_list, target_list, mode] = ...
  inner_check_arguments(base_list, target_list);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
idx = [];
list_len = length(base_list);
switch mode
  case 0 % string
    new_list = cell(1);
    new_cnt = 1;
    for i_elm = 1:list_len
      if ~any(strcmp(base_list{i_elm}, target_list))
        idx = [idx;i_elm];
        new_list{new_cnt} = base_list{i_elm};
        new_cnt = new_cnt + 1;
      end
    end
    
  case 1 % numeric
    new_list = [];
    for i_elm = 1:list_len
      if ~any(base_list(i_elm) == target_list)
        idx = [idx;i_elm];
        new_list = [new_list; base_list(i_elm)];
      end
    end
end

if ~isempty(new_list{1})
  new_list = vb_util_arrange_list(new_list);
  idx = vb_util_arrange_list(idx);
else
  new_list = [];
  idx = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base_list, target_list, mode] = ...
  inner_check_arguments(base_list, target_list)
func_ = mfilename;
if isempty(base_list)
  error('(%s)base_list is a required parameter', func_);
end

if isempty(target_list)
  error('(%s)target_list is a required parameter', func_);
end

if isnumeric(base_list) && isnumeric(target_list)
  mode = 1;
elseif ~isnumeric(base_list) && ~isnumeric(target_list)
  mode = 0;
else
  error('(%s)base_list and target_list are different type', func_);
end

base_list = vb_util_arrange_list(base_list);
target_list = vb_util_arrange_list(target_list);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
