function [result,idx] = vb_util_check_string_lists(base, target)
% check two string lists whether all element of target are included by base
% [usage]
%   [result,idx] = vb_util_check_string_lists(base,target)
% [input]
%     base : <required> string list as baseline
%          :  - (cell array)
%          :  - [n x 1] or [1 x n]
%   target : <required> string list that is checked
%          :  - (cell array)
%          :  - [n x 1] or [1 x n]
% [output]
%   result : <<boolean>>
%          :   true : base list includes all the elements of target
%          :  false : all the elements of target are not included in base
%      idx : index of base which are included in target[N x 1]
% [note]
%   @see vb_util_arrange_list
% [history]
%   2006-12-05 (Sako) initial version
%   2007-07-30 (Sako) added return value 'idx'
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base', 'var'), base = []; end
if ~exist('target', 'var'), target = []; end
[base, target] = inner_check_arguments(base, target);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
idx = [];
result = true;

Ntarget = length(target);

for i = 1:Ntarget
  if sum(strcmp(base, target{i})) == 0
    result = false;
%     warning('''%s'' is not included in base', target{i});
  else
    idx = [idx; find(strcmp(base, target{i}) ~= 0)];
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base, target] = inner_check_arguments(base, target)
func_ = mfilename;
if isempty(base)
  error('(%s)base is a required parameter', func_);
end

if isempty(target)
  error('(%s)target is a required parameter', func_);
end

if ~iscell(base)
  error('(%s)base must be cell array', func_);
end

if ~iscell(target)
  error('(%s)target must be cell array', func_);
end

% arrange to [N x 1]
base   = vb_util_arrange_list(base);
target = vb_util_arrange_list(target);

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
