function [result,idx] = vb_util_check_numerical_lists(base, target)
% check two numerical lists whether target is included by base
% [usage]
%   [result,idx] = vb_util_check_numerical_lists(base, target)
% [input]
%     base : <required> numerical list of baseline
%          :  - [n x 1] or [1 x n]
%   target : <required> numerical list that is checked
%          :  - [n x 1] or [1 x n]
% [output]
%   result : <<boolean>>
%          :   true : base includes all the elements of target
%          :  false : all the elements of target are not included in base
%      idx : corresponding index of base
%          : [Nidx x 1]
% [note]
%   @see vb_util_arrange_list
%   @see vb_util_check_string_lists
% [history]
%   2007-06-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base', 'var'), base = []; end
if ~exist('target', 'var'), target = []; end
[base, target] = inner_check_arguments(base,target);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
idx = [];
result = true;

for i = 1:size(target,1)
  tmp_idx = find(base == target(i));
  if isempty(tmp_idx)
    result = false;
%     warning('''%d'' is not included in base_list', target(i));
  else
    idx = [idx;tmp_idx];
  end
end
return;

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base, target] = inner_check_arguments(base, target)
func_ = mfilename;

if isempty(base)
  error('(%s)base_list is a required parameter', func_);
end

if isempty(target)
  error('(%s)target_list is a required parameter', func_);
end

% arrange to [N x 1]
base   = vb_util_arrange_list(base);
target = vb_util_arrange_list(target);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
