function [tbl] = vb_table_delete(tbl, key)
% delete record from table.
% [USAGE]
%    [tbl] = vb_table_delete(tbl, key);
% [IN]
%    tbl : table data.
%    key : key             [string]
% [OUT]
%    tbl : updated table data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tbl', 'var')
    error('tbl is a required parameter.');
end
if ~exist('key', 'var')
    error('key is a required parameter.');
end
if ~ischar(key)
    error('key should be string');
end

%
% --- Main Procedure
%
if ~isempty(tbl)
    ix = strmatch(key, {tbl.key}, 'exact');
    if ~isempty(ix)
        tbl(ix) = [];
    end
end

%
% --- After check
%
if nargout ~= 1
    error('you need to receive an updated table data.');
end
