function	[fid, result, data, next_line] = ...
			vb_read_from_key_line(fid, key, next_line)
% Search keyword in file 
%  [fid, result, data, next_line] = vb_read_from_key_line(fid,key)
%  [fid, result, data, next_line] = vb_read_from_key_line(fid,key,next_line)
% --- Input
% fid : file handle 
% key : keyword at the beggining of the line
% next_line : 
%   if thos is given, file pointer is at the next line of this line string
% --- Output
% fid  : file pointer is at the next line of the keyword line
% data : [num_key_line x num_in_one_line]
% if result is empty, key is not find
% if result > 0, result is position index of key in next_line
% next_line : next line to last keyword line
%
% --- example text file
% num= 1.0 2
% num= 1.1 3
% num= 1.2 4
%
%  > [fid, result, data] = vb_read_from_key_line(fid,'num=');
%  > data = [1.0 2; 1.1 3; 1.2 4]
%
% Masa-aki Sato 2008-07-25
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
data = [];

if nargin < 3, next_line = fgetl(fid); end;

% read data
while 1
    if ~ischar(next_line), break, end;
    
    result = strfind(next_line,key);
	if isempty(result), break, end;
	
	x = sscanf(next_line(result+length(key):end),'%f');
	data = [data; x'];
	
	next_line = fgetl(fid);
end

return

% seek to key
%while 1
%    next_line = fgetl(fid);
%    if ~ischar(next_line), result = []; break, end;
%    
%    result = strfind(next_line,key);
%	if ~isempty(result), break, end;
%end
%
%if nargout < 3, return; end



% K = STRFIND(TEXT,PATTERN) ϡʸ TEXT ǡʸ PATTERN и
%  ǽΥǥåϤޤ

%next_line = 'hpi 001 -0.068694 -0.043644 -0.042834';
%key = 'hpi';
%    result = strfind(next_line,key);
%	x = sscanf(next_line(result+length(key):end),'%d %f %f %f')
%	x = sscanf(next_line(result+length(key):end),'%f')
%
%return
