function varargout = vb_property_dlg(varargin)
% Create property dialog. 
%
% [syntax]
% v_out = vb_property_dlg(property_names,values,description)
%
% [input]
% property_names: <<cell>> String cell of property names. 
% values        : <<cell>> String cell of property default values. Its
%                 length must be the same with length(property_names).
% description   : <<cell>> String cell of descrption of properties.
%
% [output]
% v_out: <<cell>> String cell of property values. 
%
% [example]
% >> property_names = {'Colorbar','Max','Min'};
% >> default_values = {'1',num2str(Jmax_plot),num2str(Jmin_plot)};
% >> description    ...
% >>    = {'Colorbar is attached (1) or not (0).', ...
% >>       'Maximum value of the absolute value plotted.', ...
% >>       ['Minimum threshold; vertices with values lower than ' ...
% >>        'the threshold are not plotted.']};
% >> values = vb_property_dlg(property_names,default_values,description);
% >> 
% >> if isempty(values),
% >>   return;
% >> end
% >>
% >> iscbar    = str2num(values{1});
% >> Jmax_plot = str2num(values{2});
% >> Jmin_plot = str2num(values{3});
%
% [history]
% 2011-01-11 taku-y
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Begin initialization code
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @vb_property_dlg_OpeningFcn, ...
                   'gui_OutputFcn',  @vb_property_dlg_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);

if nargin && ischar(varargin{1}), % init/invoke callback func
  gui_State.gui_Callback = str2func(varargin{1});
end

if nargout,
  [varargout{1:nargout}] = gui_mainfcn(gui_State,varargin{:});
else
  gui_mainfcn(gui_State,varargin{:});
end

% --- Executes just before vb_property_dlg is made visible.
function vb_property_dlg_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to vb_property_dlg (see VARARGIN)

% Choose default command line output for property_dlg
handles.output = '';
handles.property_names = varargin{1};
handles.description = varargin{3};
values = varargin{2};
set(handles.figure1,'UserData',values);

% Initialize listbox1 and edit1 and text4
for i=1:length(varargin{1})
  listbox1_str{i} = [handles.property_names{i} ': ' values{i}];
end
set(handles.listbox1,'String',listbox1_str);
set(handles.edit1,'String',values{1});
set(handles.text4,'String',handles.description{1});

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes vb_property_dlg wait for user response (see UIRESUME)
uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = vb_property_dlg_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = get(handles.figure1,'UserData');
delete(handles.figure1);

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

uiresume(handles.figure1);

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.figure1,'UserData','');
uiresume(handles.figure1);

% --- Executes on selection change in listbox1.
function listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox1

ix     = get(hObject,'Value');
values = get(handles.figure1,'UserData');
set(handles.edit1,'String',values{ix});
set(handles.text4,'String',handles.description{ix});

% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double

ix = get(handles.listbox1,'Value');
values = get(handles.figure1,'UserData');
value = get(hObject,'String');
values{ix} = value;
set(handles.figure1,'UserData',values);
listbox1_str = get(handles.listbox1,'String');
listbox1_str{ix} = [handles.property_names{ix} ': ' value];
set(handles.listbox1,'String',listbox1_str);

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

