function	dd = vb_mutual_distance(X)
% calculate distance between points
%  dd = vb_mutual_distance(X)
% --- Input
% X : N point coordinate [ N x D ]
% --- Output
% dd(n,m) : distance between X(n.:) and X(m,:)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N, D] = size(X);

dd = zeros(N,N);

for n=1:N
	dd(:,n) = sqrt( sum( vb_repadd(X , - X(n,:)).^2 , 2) );
end
