function err_code = vb_mkdir(target_dir)
% compatible mkdir for MATLAB6 or MATLAB7,8
% [usage]
%   err_code = vb_mkdir(target_dir)
% [input]
%   target_dir : directory name which you want to make
% [output]
%  return_code : return code
%              :  =0 : failure
%              :  =1 : success
% [note]
% 
% [history]
%   2006-10-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

err_code = 1;
if exist(target_dir, 'dir')
   return;
end

if vb_matlab_version('<=', '6')
  if isequal(target_dir(length(target_dir)),filesep)
    target_dir(length(target_dir)) = '';
  end
  
  [vt_path,vt_name] = fileparts(target_dir);
  
  mkdir(vt_path,vt_name);
  
else
  mkdir(target_dir);
end

%%% END OF FILE %%%
