function vb_matfile_to_v6(inputfile, output_v6, output_org)
% convert MATLAB7 or later format file into MATLAB6 format file. 
% USAGE:
%    vb_matfile_to_v6(inputfile);
%    vb_matfile_to_v6(inputfile, output_v6);
%    vb_matfile_to_v6(inputfile, output_v6, output_org);
% [IN]
%    inputfile  : <required> input MAT-FILE
%    output_v6  : <optional> output file the data of which is
%               :  converted to version 6 format
%               :  [same as inputfile]
%    output_org : <optional> output file which is original data
%               :  if this is the same as output_v6, original data
%               :  will not be lost.
%               :  [same as inputfile]
% [NOTE]
%    This function should be executed in MATLAB version 7 or later.
%
% 2007-12-04 rhayashi
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if vb_matlab_version < 7
    error('This function should be executed in MATLAB version 7 or later. File not converted.');
end
if ~exist('inputfile', 'var')
    error('inputfile is a required parameter.');
end
if exist(inputfile, 'file') ~= 2
    error('inputfile not found.');
end

if ~exist('output_v6', 'var'), output_v6 = ''; end
if ~exist('output_org', 'var'), output_org = ''; end
if isdir(output_org), output_org = fullfile(output_org, inputfile); end

%
% --- Main Procedure
%
if isempty(output_v6), output_v6 = inputfile; end

if ~strcmp(output_v6, output_org) && ~isempty(output_org)
    do_copy = true;
    if exist(output_org, 'file') == 2
        res = questdlg([output_org ' is already exists. Overwrite?'], ...
                        'Copy Original file', 'Yes', 'No', 'Yes');
        if strcmp(res, 'No'), do_copy = false; end
    end
    if do_copy
        % save original file
        [result, msg, msg_id] = copyfile(inputfile, output_org);
        % copy failed
        if result == 0
            fprintf('XXX : original file copy was failed. output_org = %s\n', ...
                    output_org);
            fprintf('XXX : conversion was terminated.\n');
            return;
        end
        fprintf('original file copy was succeeded.\n');
    else
        fprintf('original file copy was cancelled.\n');
    end
end

% load variable in the file as fields of struct S.
S = load(inputfile);

do_convert = true;
if ~strcmp(inputfile, output_v6) && exist(output_v6, 'file') == 2
    res = questdlg([output_v6 ' is already exists. Overwrite?'], ...
            'Conversion', 'Yes', 'No', 'Yes');
    if strcmp(res, 'No'), do_convert = false; end
end

% save the field of structure S in the file as an independent variable. 
if do_convert
    save(output_v6, '-STRUCT', 'S', '-V6');
    fprintf('file conversion was succeeded.\n');
else
    fprintf('file conversion was cancelled.\n');
end
