function time = vb_index_to_time(index,meg_info)
% Return actual time (ms) for given sample indices
%
% --- Syntax
% time = vb_index_to_time(index,MEGinfo)
%
% --- History
% 2008-10-30 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

sample_freq     = vb_meginfo_get_sampling_frequency(meg_info);
Nsample         = vb_meginfo_get_sample_number(meg_info);
pretrigger      = vb_meginfo_get_pre_trigger(meg_info);
if isempty(pretrigger)
    pretrigger = 0;
end

% sampling length(msec).
sampling_length = 1000/sample_freq;

% time list of sample points(msec)
sampling_point = -(sampling_length * pretrigger) : sampling_length : ...
    (sampling_length * (Nsample-pretrigger-1));

for k=1:length(index)
  % array over flow check
  if index(k) > length(sampling_point)
    index(k) = length(sampling_point);
  end
  % return time
  time(k) = sampling_point(index(k));
end
