function	cmap = vb_get_class_color(Nclass)
% Make color map for class label
%  cmap = vb_get_class_color(Nclass)
% --- Input
% Nclass : # of class
% --- Output
% cmap : colormap matrix for class plot
%      : [Nclass x 3]
%
% 2006-11-16 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('Nclass','var'), Nclass = 64; end

% Nclass = Nmap^3 : log(Nmap) = log(Nclass)/3 : 

Nmap   = ceil(exp(log(Nclass)/3));
clevel = (0:Nmap)/Nmap;

[c1, c2, c3] = ndgrid(clevel);

cmap = [c1(:), c2(:), c3(:)];
N    = size(cmap,1);
cmap = cmap(2:(N-1),:);
N    = N - 2;

% load precalculated random permutation
fname = 'rand_index.mat';

if exist(fname,'file'), 
	load(fname,'rand_indx')
	%fprintf('Load index file\n')
	ix = rand_indx( rand_indx <= N );
else
	ix   = randperm(N);
end

cmap = cmap(ix(1:Nclass),:);

return
%% --- END --- %%
% gray, hot, cool, bone, copper, pink, flag, prism, 

N = ceil(Nclass/Nmap);
ncmap = zeros(N*Nmap,3);
ix = 1:Nmap;

%cadd = gray(N) + flag(N);
cadd = gray(N);

for n = 1:N
 tmap = cmap + repmat(cadd(n,:), [Nmap 1]); 
 ncmap(ix,:) = tmap/max(tmap(:));
 ix = ix + Nmap;
end

ncmap = ncmap(1:Nclass,:);
