function [dir, fnames] = vb_file_select(ext, caption, save_mode)
% file select dialog
% [USAGE]
%    [dir, fnames] = vb_file_select(<ext> [,caption] [,save_mode]);
% [IN]
%      ext     : file extension (ex. {'.img', '.txt'}) {Nx1}
%      caption : dialog title(string)                  [string]
%    save_mode : = true  : save file selection mode.
%                = false : load file selection mode. <<DEFAULT>>
%
% [OUT] dir       : selected directory.
%       fnames{n} : selected filenames.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
persistent HISTORY; % file choice history

dir = [];
fnames= [];

if ~exist('save_mode', 'var')
    save_mode = false;
end

h = file_dialog;
% Set extension
h = set(h, 'file_extensions', ext);

% Set caption
if exist('caption', 'var') && ~isempty(caption)
    h.dialog_title = caption;
end

% Set Save mode
h = set(h, 'save_mode', save_mode);

% Add history to dialog
hist_num = length(HISTORY);
if ~isempty(HISTORY)
    h = set(h, 'hist_dir', HISTORY);
    h = set(h, 'current_dir', char(HISTORY{hist_num}));
end

[dir fnames] = visible(h);

% Save history
if ~isempty(dir)
    % Duplication check
    idx = strmatch(dir, HISTORY, 'exact');
    if isempty(idx)
        HISTORY{hist_num+1} = dir;
    else
        HISTORY(idx) = [];
        HISTORY{end+1} = dir;
    end
end
