function	[err, Sx, Sy] = vb_err_array(x,y)
% calculate difference of two arrays
% err = vb_err_array(x,y) 
%     = sum( abs(x-y) )/sum( abs(x) )
%     = sum( abs(x-y) ) if sum( abs(x) ) == 0
% --- Input
% x, y : numerical array (any size)
% --- Output
% err : normalized error
% --- Error info
% [err, Sx, Sy] = vb_err_array(x,y)
%
% if size of x & y is different, 
%  err = -1 is returned, and error massage is printed
%  Sx, Sy = size of x & y
%
% 2006/10/3 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Sx = size(x);
Sy = size(y);
Nx = length(Sx);
Ny = length(Sy);

% Check size of x & y
if Nx ~= Ny | sum(abs(Sx - Sy)) > 0
	fprintf('Size of two arrays are different\n')
	fprintf('Size = ')
	disp(Sx)
	fprintf('Size = ')
	disp(Sy)
	err = -1;
	return
end

xx  = sum(abs(x(:)));
err = sum(abs(x(:)-y(:)));

if xx > 0,
	err = err/xx;
end

%%% -- END of program

% if x and y is vector, make it a row vector
%if Nx==2 & Ny==2
%	if Sx(1)==1, Sx(1) = Sx(2); Sx(2) = 1; end;
%	if Sy(1)==1, Sy(1) = Sy(2); Sy(2) = 1; end;
%end
