function vb_convert_var2text(var, save_spec)
% Save field name and its value for cell or structure array as text file
% [USAGE]
%    vb_convert_var2text(<var>[,save_spec]);
% [IN]
%        var : cell array or structure array
%  save_spec : Option parameter
%     .filename       : file name
%     .contents       : = true  : Show field value [DEFAULT]
%                       = false : Not show for field value
%     .type_opt       : = true  : Show variable type
%                     : = false : Not show for variable type [DEFAULT]
%     .cell_opening   : = true  : Open cell array at the same level
%                     : = false : Only show cell{1,1}  [DEFAULT]
%     .struct_opening : = true  : Open structure array
%                     : = false : Only show struct(1) [DEFAULT]
%
% 롦¤ѿγع¤(ե̾)ͤƥȥե¸
% [USAGE]
%    vb_convert_var2text(<var>[,save_spec]);
% [IN]
%        var : ѿ
%  save_spec : ¸ץ
%     .filename
%     .contents       : = true  : ѿͤ񤭽Ф[DEFAULT]
%                                 (char, 1xNɽΤ)
%                       = false : ѿͤ񤭽Фʤ
%     .type_opt       : = true  : 񤭽Ф
%                     : = false : 񤭽Фʤ [DEFAULT]
%     .cell_opening   : = true  : Ʊ٥ˤ륻ѿ򳫤
%                     : = false : Ʊ٥ˤ륻ѿ򳫤ʤ
%                                 (cell{1,1}Τɽ [DEFAULT]
%     .struct_opening : = true  : Ʊ٥ˤ빽¤Τ򳫤
%                     : = false : Ʊ٥ˤ빽¤Τ򳫤ʤ
%                                (struct(1)Τɽ) [DEFAULT]
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('var', 'var')
    error('var is a required parameter.');
end

if ~exist('save_spec', 'var')
    save_spec = struct;
end
if ~isfield(save_spec, 'filename')
    save_spec.filename = 'var_struct.txt';
end
if ~isfield(save_spec, 'contents')
    save_spec.contents = true;
end
if ~isfield(save_spec, 'type_opt')
    save_spec.type_opt = false;
end
if ~isfield(save_spec, 'cell_opening')
    save_spec.cell_opening = false;
end
if ~isfield(save_spec, 'struct_opening')
    save_spec.struct_opening = false;
end

%
% --- Main
%

% file open
fid = fopen(save_spec.filename, 'wt');
if fid == -1, return; end
if save_spec.type_opt
    fprintf(fid, '[]Ϸ̾\n');
end

% root
indent_level = 0;
% 
add_node(indent_level, fid, var, inputname(1), save_spec); 
fclose(fid);

% open file
%edit(save_spec.filename);
%
% ----------------------------------------------------
%
function add_node(indent_level, fid, element, element_name, save_spec)
% ¤Ρ򷡤ʤǡ롦¤ΰʳѿˤɽ롣

% ǥ
indent = repmat('\t', 1, indent_level);
element_info = whos('element');

if isstruct(element)
	% ¤ɽ
    % ե̾ɽ
    Nstruct = length(element);
    if indent_level ~= 0 && save_spec.struct_opening == false && Nstruct>2
        Nstruct = 1;
    end
    for j=1:Nstruct
        if ~isempty(element_name)
            % ι¤Τˤ̾ʤΤǡɽʤ
            fprintf(fid, [indent, '%s'], element_name);
            if Nstruct >= 2
                fprintf(fid, '(%d)', j);
            end
            if save_spec.type_opt
                fprintf(fid, ' : [%s]', element_info.class);
            end
            fprintf(fid, '\n');
        end
        names = fieldnames(element(j));
        for(k=1:length(names))
            add_node(indent_level+1, fid, element(j).(names{k}), ...
            		['.' names{k}], save_spec);
        end
    end
elseif iscell(element)
    % ɽ
    [m, n] = size(element);
    Nsize = length(element_info.size);
    if Nsize > 2 
        % ʾΥɽʤ
        dimStr = strrep(mat2str(element_info.size), ' ', 'x');
        fprintf(fid, [indent, '\tsize=%s, bytes=%d\n'], ...
        		dimStr, element_info.bytes);
        return;
    end
    if indent_level ~= 0 && save_spec.cell_opening == false, m=1; n=1; end
    for k=1:m
        for j=1:n
            % ȤȤäƤơĴ٤
            if save_spec.type_opt
                cell_name = sprintf('%s{%d,%d} : [%s]', ...
                		element_name, k, j, element_info.class);
            else
                cell_name = sprintf('%s{%d,%d}', element_name, k, j);
            end
            fprintf(fid, [indent,'%s\n'], cell_name);
            if strcmp(element_info.class, 'struct')
                % ι¤Τˤ̾ʤΤǡ
                % ɽǥȥ٥夲ʤ
                add_node(indent_level, fid, element{k, j}, ...
                		'|__', save_spec);
            else
                % Ȥɽ
                add_node(indent_level+1, fid, element{k, j}, ...
                		'|__', save_spec);
            end
        end
    end
else
    % ñѿ
    % ͥõñȤѿˤʤä餳ˤɽ
    if ~isempty(element_name)
        if save_spec.type_opt
            fprintf(fid, [indent,'%s : [%s]\n'], ...
            		element_name, element_info.class);
        else
            fprintf(fid, [indent,'%s\n'], element_name);
        end
        % ѿ¸OFFʤ餳ǥ꥿
        if save_spec.contents == false, return; end
        % ѿ¸
        Nsize = length(element_info.size);
        dimStr = strrep(mat2str(element_info.size), ' ', 'x');
        try
            if ischar(element) || (Nsize<=2 && element_info.size(1) == 1)
                fprintf(fid, [indent, '\t%s\n'], mat2str(element));
            else
                fprintf(fid, [indent, '\tsize=%s, bytes=%d\n'], ...
                		dimStr, element_info.bytes);
            end
        catch
            fprintf(fid, [indent,'\tCan''t display, variable type = %s\n'],...
             element_info.class);
        end
    end
end
