function [N] = vb_stack_get_length(obj)
% return number of items that stack has.
% [USAGE]
%    [N] = vb_stack_get_length(<obj>);
% [IN]
%    obj : stack object
% [OUT]
%    N : item number that stack has.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
switch(obj.class_type)
    case {'m_stack', 'f_stack'}
        N = length(obj.queue);
    otherwise
        error('invalid object is inputted.');
end

%
% --- After check
%
